<?php
/**
 * Plugin Name: IPv4/IPv6
 * Plugin URI: http://ximalas.info/widgets/ipv4ipv6/
 * Description: A widget that outputs whether the user uses IPv4 or IPv6, and from what address.
 * Version: 1.0
 * Author: Trond Endrest&oslash;l
 * Author URI: http://ximalas.info
 * License: GPLv3
 *
 * Copyright  2011 Trond Endrestl <Trond.Endrestol@ximalas.info>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Add function to widgets_init that'll load our widget.
 *
 * @since 1.0
 */
add_action('widgets_init', 'IPv4_IPv6_load_widgets');

/**
 * Register our widget.
 * 'IPv4_IPv6' is the widget class used below.
 *
 * @since 1.0
 */
function IPv4_IPv6_load_widgets() {
	register_widget('IPv4_IPv6');
}

/**
 * IPv4_IPv6 Widget class.
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update.  Nice!
 *
 * @since 1.0
 */
class IPv4_IPv6 extends WP_Widget {
	function IPv4_IPv6() {
		// widget actual processes

		/* Widget settings. */
		$widget_ops = array( 'classname' => 'IPv4_IPv6', 'description' => __('A widget that displays the user\'s IP address, whether it\'s IPv4 or IPv6.', 'IPV4/IPv6') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'ipv4-ipv6-widget' );

		/* Create the widget. */
		$this->WP_Widget( 'ipv4-ipv6-widget', __('IPv4/IPv6 Widget', 'IPv4/IPv6'), $widget_ops, $control_ops );
	}

	function form($instance) {
		// outputs the options form on admin
		$defaults = array('title' => 'IPv4/IPv6');
		$instance = wp_parse_args((array)$instance, $defaults); ?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>">Title:</label>
			<input id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $instance['title']; ?>" style="width:100%;" />
		</p>
	<?php
	}

	function update($new_instance, $old_instance) {
		// processes widget options to be saved
		$instance = $old_instance;
		/* Strip tags (if needed) and update the widget settings. */
		$instance['title'] = strip_tags( $new_instance['title'] );
		return $instance;
	}

	function widget($args, $instance) {
		// outputs the content of the widget
		extract($args);

		$title = apply_filters('widget_title', $instance['title'] );

		echo $before_widget;

		if ($title)
			echo $before_title . $title . $after_title;

		echo "You are using <STRONG>";

		if (strstr($_SERVER["REMOTE_ADDR"], ':') != FALSE)
			echo "IPv6";
		else
			echo "IPv4";

		echo "</STRONG> from <STRONG><CODE>" . strtoupper($_SERVER["REMOTE_ADDR"]) . "</CODE></STRONG>";

		echo $after_widget;
	}

}
?>
